@extends('frontend.layouts.master')
@section('css')
    <style>
        .home-title {
            margin-bottom: 20px;
        }

    </style>
    @php
    $website = DB::table('websites')
        ->latest()
        ->first();
    $p_categorys = DB::table('categories')
        ->latest()
        ->get();
    @endphp
@endsection
@section('front-content')

    <section id="contact" class="contact">
        <div class="container aos-init aos-animate" data-aos="fade-up">
            <div class="row gy-4 mt-4  justify-content-md-center">
                <div class="col-lg-4 pt-2" style="border:1px solid #cecece;">
                    <div class="mb-10 text-center">
                        <a href="javascript:void(0)">
                            <img src="{{ URL::to(website_logo()) }}" alt="logo" width="100" />
                        </a>
                    </div>
                    <form action="{{ route('refer-user-register') }}" method="POST" role="form" >
                        @csrf
                        <div class="form-group mt-3">
                            <input type="hidden" class="form-control" name="user_code" value="{{ $code }}">
                            <input type="text" class="form-control" placeholder="Full Name" name="name" required="">
                        </div>
                        <div class="form-group mt-3">
                            <input type="email" class="form-control" placeholder="Email" name="email" required="">
                        </div>
                        <div class="form-group mt-3">
                            <input type="password" class="form-control" placeholder="Password" name="password" required="">
                        </div>
                        <div class="form-group mt-3">
                            <select class="form-select" name="country" aria-label="Default select example">
                                <option value="">Select Country</option>
                                @foreach (countrys() as $key=>$country)
                                    <option value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        
                        
                        
                        
                        
                        
                        
                          
                            @if (site_info()->captcha_verify_active == 1)
    <div class="form-group mb-3">
        <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}" id="recaptcha"></div>
        @error('g-recaptcha-response')
            <span class="my_error" style="display: block; color: red;">{{ $message }}</span>
        @enderror
    </div>
@endif

<!-- reCAPTCHA Warning Message -->
<div id="recaptchaWarningMessage" style="display: none; color: red; font-weight: bold; margin-top: 10px;">
    Please complete the reCAPTCHA before registration.
</div>



<script>
    function checkRecaptcha(event) {
        var recaptchaResponse = grecaptcha.getResponse(); // reCAPTCHA রেসপন্স চেক করুন
        if (!recaptchaResponse) {
            event.preventDefault(); // সাবমিট আটকান
            document.getElementById('recaptchaWarningMessage').style.display = 'block'; // এরর মেসেজ প্রদর্শন করুন
        } else {
            document.getElementById('recaptchaWarningMessage').style.display = 'none'; // এরর মেসেজ লুকিয়ে রাখুন
        }
    }
</script>


                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        <div class="text-center mt-4"><button type="submit" class="btn btn-info btn-m" onclick="checkRecaptcha(event)">Create Account</button></div>
                    </form>
                    
                    
                    
                    
                    
                    <p class="text-center mb-6 mt-4">
                        Have an account?
                        <a href="{{ route('login') }}" class="text-primary hover:underline">
                            Sign In
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </section>

@endsection
 <script src="https://www.google.com/recaptcha/api.js" async defer></script>